############################################################################
##       MERGENEBXML.PL  -  this merges elements of NEB XML file          ##
############################################################################

$infile = $ARGV[0];
$outfile = $infile;
$outfile =~ tr/./:/;
@names = split(/:/,$outfile);
$outfile = $names[0]."_merged\.xml";

open (IN, "<$infile") || die "Cannot open $infile file.";
open (OUT, ">$outfile") || die "Cannot open $outfile file.";

$labref = 0;
$shift = 0;
$mergedline = "";

while(<IN>)  {
   chop();
   if (/\<reference\>/ && /\<\/reference\>/)  {
      print OUT "$_\n";
   }  elsif (/\<reference\>/) {
      $labref = 1;
      $mergedline = $mergedline.$_;
   }  elsif (/\<\/reference\>/) {
      $mergedline = $mergedline.$_;
      $labref = 0;
      &ReplaceStomackBags($mergedline);
      print OUT "$cleanedstr\n";
      $mergedline = "";      
   }  else  {
      if ($labref == 1)  {
         $mergedline .= $_;
      } else {
         &ReplaceStomackBags($_);
         print OUT "$cleanedstr\n";   
      }
   }
}
#############################################################################
##      SUBROUTINE   ReplaceStomackBags                                    ##
##      This subroutine cleans bags from LaTeX stomack                     ##
#############################################################################

sub ReplaceStomackBags  {
   $cleanedstr = $_[0];
###   print "$cleanedstr\n";
   $cleanedstr =~ s/\\discretionary \{-\}\{\}\{\}//g;
   $cleanedstr =~ s/\\\~//g;
   $cleanedstr =~ s/\\hspace +.+\}//g;   
   $cleanedstr =~ s/\{//g;
   $cleanedstr =~ s/\}//g;
   $cleanedstr =~ s/--/-/g;
   $cleanedstr =~ s/---/-/g;
   $cleanedstr =~ s/\\\$/\[dollar\]/g;
   $cleanedstr =~ s/\$//g;
   $cleanedstr =~ s/\[dollar\]/\$/g;
   $cleanedstr =~ s/\\~//g;
   $cleanedstr =~ s/\\"//g;
   $cleanedstr =~ s/\\u//g;
   $cleanedstr =~ s/\\textlatin//g;
   $cleanedstr =~ s/\\LaTeX/LaTeX/g;
   $cleanedstr =~ s/\\latex/LaTeX2e/g;
   $cleanedstr =~ s/ +\,/\,/g;
   $cleanedstr =~ s/ +\./\./g;
   $cleanedstr =~ s/ +\\ +/ /g;
} 
#############################################################################
